/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.filesystem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jemu.core.device.filesystem.DskMaster;
import jemu.core.device.filesystem.DskSector;
import jemu.core.device.filesystem.DskType;

public class DskSectorCatalog {
    private DskMaster master;
    int fillerByte;
    String filename;
    List<Integer> catsId = new ArrayList<Integer>();
    List<DskSector> catsSector = new ArrayList<DskSector>();
    int sectorIncrement;
    int sectorLength;
    byte[] entriesSector = new byte[16];
    boolean leftEntries = true;

    public DskSectorCatalog(DskMaster master) {
        this.master = master;
    }

    public boolean scan(ByteArrayInputStream bis) throws IOException {
        this.fillerByte = bis.read();
        if ((this.fillerByte & 0xFF) == 229) {
            bis.skip(31L);
            return false;
        }
        byte[] filename = new byte[11];
        bis.read(filename);
        this.filename = this.master.arrayToString(filename);
        this.sectorIncrement = bis.read();
        bis.read();
        bis.read();
        this.sectorLength = bis.read();
        this.entriesSector = new byte[16];
        bis.read(this.entriesSector);
        this.catsId = this.master.findCatsId(this.entriesSector);
        this.catsSector = this.master.findCatsSector(this.entriesSector);
        return true;
    }

    public void scan(ByteArrayOutputStream bos, Map<String, DskSectorCatalog> previousCats) throws IOException {
        if (this.fillerByte == 229) {
            for (int i = 0; i < 32; ++i) {
                bos.write(229);
            }
            return;
        }
        bos.write(new byte[]{(byte)this.fillerByte});
        byte[] entryFileName = this.master.stringToArray(this.master.realname2cpcname(this.filename));
        bos.write(entryFileName);
        bos.write(new byte[]{(byte)this.sectorIncrement});
        bos.write(new byte[]{0, 0});
        bos.write(new byte[]{(byte)this.sectorLength});
        int nbTrou = 0;
        if (this.master.type == DskType.DOSD40 || this.master.type == DskType.SDOS) {
            if (previousCats != null && previousCats.get(this.filename) != null) {
                this.leftEntries = !previousCats.get((Object)this.filename).leftEntries;
                previousCats.put(this.filename, this);
            } else {
                this.leftEntries = true;
                previousCats.put(this.filename, this);
            }
            if (!this.leftEntries) {
                for (int k = 0; k < 8; ++k) {
                    bos.write(0);
                    ++nbTrou;
                }
            }
        }
        for (Integer cat : this.catsId) {
            if (null == this.master.type) continue;
            switch (this.master.type) {
                case DOSD40: 
                case SDOS: {
                    bos.write((byte)cat.intValue());
                    break;
                }
                case DOSD2: 
                case DOSD10: 
                case DOSD20: {
                    byte k1 = (byte)(cat & 0xFF);
                    byte k2 = (byte)((cat & 0xFF00) >> 8);
                    bos.write(k1);
                    bos.write(k2);
                    ++nbTrou;
                    break;
                }
                case PARADOS80: 
                case PARADOS41: 
                case PARADOS40D: 
                case SS40: 
                case SYSTEM: 
                case VORTEX: {
                    bos.write((byte)cat.intValue());
                    break;
                }
            }
        }
        for (int j = 0; j < 16 - (this.catsId.size() + nbTrou); ++j) {
            bos.write(new byte[]{0});
        }
    }

    public String toString() {
        String s = "DskSectorCatalog\n" + this.catsId.size() + " sectors references\n";
        for (Integer cat : this.catsId) {
            s = s + "cat:" + String.format("#%02X", cat) + "\n";
        }
        return s;
    }
}

